from bpy.types import Operator
from ....libs.functions.basics import deselect_all_objects, set_active_object
from ....libs.functions.get_common_vars import get_common_vars
from .common_methods import reset_properties_to_defaults


class FLUIDLAB_OT_ff_forces_colliders_add(Operator):
    bl_idname = "fluidlab.forces_collliders_add"
    bl_label = "Add Force"
    bl_description = "Add Collider Force"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):

        previous_selection = context.selected_objects
        previous_active = context.active_object

        fluid_colliders = get_common_vars(context, get_fluid_colliders=True)

        active_collider = fluid_colliders.active
        if not active_collider:
            print("no active_collider!")
            return {'CANCELLED'}

        # Ahora los colliders pueden ser varios:
        colliders_obs = [c_ob.ob for c_ob in active_collider.colliders]
        for collider_ob in colliders_obs:

            deselect_all_objects(context)
            set_active_object(context, collider_ob)
            collider_ob.select_set(True)
            field = collider_ob.field

            if field.type == 'NONE':
                field.type = 'TURBULENCE'
                reset_properties_to_defaults(field)

            if previous_active:
                set_active_object(context, previous_active)

            deselect_all_objects(context)
            if previous_selection:
                for obj in previous_selection:
                    obj.select_set(True)

        return {'FINISHED'}